package org.pgusb.usb4allLib;

import exceptions.Usb4allAlreadyInitializedException;
import exceptions.Usb4allException;
import exceptions.Usb4allInitException;

public class Manchester extends Usb4allDevice {
	
	//skeleton
	private static final int IN_ENDPOINT_TYPE = Usb4allDevice.BULK_IN; //Replace with the prefered In Endpoint Type.
	private static final int OUT_ENDPOINT_TYPE = Usb4allDevice.BULK_OUT; //Replace with the prefered Out Endpoint Type.
	
	public Manchester(String moduleName){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		this.moduleName=moduleName;
	}
	
	public Manchester(){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		moduleName="manch"; //Put the name of the firmware module.
	}

	public int getVersion(){
		byte[] command = new byte[1];
		byte[] version = null;
		command[0]=0x00;
		try {
			send(command);
			version = receive(4);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("La version es:" +" "+ version[0] +  " "+ version[1] +" "+ version[2] +" "+ version[3]);
		return 1;
	}

	public void sendByte(byte b){
		byte[] command = new byte[3];
		command[0]=0x10;
		command[1]=0;
		command[2]=b;
		try {
			send(command);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void sendByteT(byte b){
		byte[] command = new byte[3];
		command[0]=0x11;
		command[1]=0;
		command[2]=b;
		try {
			send(command);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
